<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Create new Spreadsheet object
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set header
$sheet->setCellValue('A1', 'Target Number');

// Add example data
$exampleData = [
    ['081219008008'],
    ['081234567890'],
    ['081345678901']
];

// Add data starting from row 2
$row = 2;
foreach ($exampleData as $data) {
    $sheet->setCellValue('A' . $row, $data[0]);
    $row++;
}

// Set column width
$sheet->getColumnDimension('A')->setWidth(20);

// Set headers for download
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="phone_call_template.xlsx"');
header('Cache-Control: max-age=0');

// Create Excel file
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
 